/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.ntfy;

import com.ibm.hwmca.fw.ntfy.TextBasedEvent;
import com.ibm.hwmca.fw.ntfy.TextField;
import com.ibm.hwmca.fw.ntfy.TextFilter;
import com.ibm.hwmca.fw.util.Trace;
import java.io.Serializable;
import java.util.EventObject;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class StringPatternFilter
extends TextFilter
implements Serializable {
    static final long serialVersionUID = -2414731366644562134L;
    private static final String TRACE_MASKT = "XNTYPFIT";
    private static final String TRACE_MASKF = "XNTYPFIF";
    private static final String TRACE_MASKD = "XNTYPFID";
    private Pattern _matcher = null;

    StringPatternFilter() {
    }

    public StringPatternFilter(String name, int op, String regex, TextField field) {
        super(name, op, regex, field);
        Trace.trace(TRACE_MASKT, "-> PatternFilter(" + name + ")");
        try {
            this._matcher = Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            Trace.trace(TRACE_MASKF, "StringPatternFilter:  invalid regular expression " + regex);
            this._matcher = null;
        }
        Trace.trace(TRACE_MASKT, "<- PatternFilter");
    }

    public boolean validateData(int op, String text) {
        try {
            Pattern.compile(text);
        }
        catch (PatternSyntaxException e) {
            return false;
        }
        return true;
    }

    public boolean pass(EventObject event) {
        Trace.trace(TRACE_MASKT, "-> pass(" + event + ")");
        if (this._matcher == null) {
            Trace.trace(TRACE_MASKF, "pass:  returning false because regular expression matcher is null");
            return false;
        }
        boolean pass = false;
        String text = this.getFieldData(((TextBasedEvent)event).getText());
        pass = this._matcher.matcher(text).matches();
        Trace.trace(TRACE_MASKT, "<- pass returns " + pass);
        return pass;
    }

    public StringBuffer parms() {
        StringBuffer parms = super.parms();
        parms.append(", regex=");
        parms.append(((Object)this._matcher).toString());
        return parms;
    }
}

